local t = Def.ActorFrame {
	LoadActor(THEME:GetPathG("", "_longSong")) .. {
		Name = "Long",
		OnCommand=function(self) self:vertalign(bottom):y(-35):zoom(0.8):pause() end
	},

	LoadActor(THEME:GetPathG("", "_song")) .. {
		OnCommand=function(self) self:zoom(0.8) end
	},
	
	Def.Sprite {
		Name = "Jacket"
	},
	
	Def.Quad {
		Name = "TextBacking",
		InitCommand=function(self)
			self:diffuse(LocalBlueColor(0.5)):vertalign(bottom):y(32):zoomto(64,0):blend(Blend.Modulate)
		end
	},
	
	Def.BitmapText {
		Name = "SongTitle",
		Font = "Common Normal",
		InitCommand=function(self)
			self:y(30):vertalign(bottom):maxwidth(256):wrapwidthpixels(256):zoom(0.25):strokecolor(Color.Black)
		end
	},
	
	SetMessageCommand=function(self,param)
		local song = param.Song
		local course = param.Course
		local theString = "???"
		local isLong = false
		
		if song then
			theString = song:FormattedSongTitle()
			self:GetChild("Jacket"):LoadFromCached("Jacket", song:GetJacketOrSubstitutePath())
			isLong = song:IsLong() or song:IsMarathon()
			if isLong then
				self:GetChild("Long"):setstate(song:IsMarathon() and 1 or 0)
			end
		elseif course then
			theString = course:GetDisplayFullTitle()
			self:GetChild("Jacket"):LoadFromCached("Jacket", course:GetBGOrSubstitutePath())
		else
			self:GetChild("Jacket"):LoadBanner(THEME:GetPathG("Common","fallback jacket"))
		end
		
		self:GetChild("Jacket"):scaletoclipped(64,64)
		self:GetChild("SongTitle"):settext(theString)
		self:GetChild("TextBacking"):zoomy((self:GetChild("SongTitle"):GetHeight() * 0.25) + 4)
		self:GetChild("Long"):visible(isLong)
	end
}

return t
